;--------------------------------------------------------------------------------------------------------------------------
; Common States Override
;--------------------------------------------------------------------------------------------------------------------------
;--------------------------------------------------------------------------------------------------------------------------
; Stance
;--------------------------------------------------------------------------------------------------------------------------

[Statedef 0]
type = S
physics = S
sprpriority = 0

[State 0, 1]
type = ChangeAnim
triggerall = FVar(1) <= 0
trigger1 = Anim != 0 && Anim != 5
trigger2 = Anim = 5 && !AnimTime
value = 0

[State 0, 1] ; Ralf Mode stance
type = ChangeAnim
triggerall = FVar(1) > 0
trigger1 = Anim != 0 && Anim != 1 && Anim != 5
trigger2 = Anim = 5 && !AnimTime
value = 1 

[State 0, 2]
type = VelSet
trigger1 = !Time
y = 0

[State 0, StopSND]
type = StopSND
trigger1 = 1
channel = 3

[State 0, 3] ;Stop moving if low velocity or 4 ticks pass
type = VelSet
trigger1 = abs(vel x) < 2
trigger2 = Time = 4
x = 0

;--------------------------------------------------------------------------------------------------------------------------
; Walk
;--------------------------------------------------------------------------------------------------------------------------

[Statedef 20]
type    = S
physics = S
sprpriority = 0

[State 211, StopSND]
type = StopSND
trigger1 = 1
channel = 3

[State 20, WalkF Velocity]
type = VelSet
trigger1 = Command = "holdfwd"
x = Const(velocity.walk.fwd.x)

[State 20, WalkB Velocity]
type = VelSet
trigger1 = Command = "holdback"
x = Const(velocity.walk.back.x)

[State 20, Walk Forward Anim]
type = ChangeAnim
triggerall = Vel x > 0
trigger1 = Anim != 20 && Anim != 5 
trigger2 = Anim = 5 && !AnimTime
value = 20 

[State 20, Walk Backward Anim]
type = ChangeAnim
triggerall = Vel x < 0
trigger1 = Anim != 21 && Anim != 5
trigger2 = Anim = 5 && !AnimTime
value = 21 

;--------------------------------------------------------------------------------------------------------------------------
; KOF Style Jumps
; Contains code by Sander71113 (sander71113@yahoo.com) used with permission from its author. 
;--------------------------------------------------------------------------------------------------------------------------

[Statedef 40]
type    = S
physics = S
anim = 40
ctrl = 0
velset = 0,0
;facep2 = 1

[State 211, StopSND]
type = StopSND
trigger1 = 1
channel = 3

[State 40, AI]
type = VarSet
triggerall = var(33) = 1
trigger1 = !time && (p2bodydist x > 0)
var(1) = 2

[State 40, Invincible] ; Cannot be grabbed by normal throws unless opponent performs an aerial one.
type = NotHitBy
trigger1 = !Time
value = SC,NT

[State 40, 4]
type = VarSet
trigger1 = !Time
var(1) = 0

[State 40, 5]
type = VarSet
trigger1 = Command = "holdfwd" && (var(1) != 2)
var(1) = 1

[State 40, 6]
type = VarSet
trigger1 = Command = "holdback" && (var(1) != -2)
var(1) = -1

[State 40, 7]
type = VarSet
triggerall = !Time && (Command = "holdfwd")
trigger1 = Command = "longjump"
trigger2 = PrevStateNo = 100
trigger3 = Prevstateno = [10,12]
var(1) = 2

[State 40, 8]
type = VarSet
triggerall = !Time && (Command = "holdback")
trigger1 = Command = "longjump"
trigger2 = Prevstateno = [10,12]
var(1) = -2

[State 40, 9]
type = StopSnd
trigger1 = !Time
channel = 1

[State 40, 10]
type = ChangeState
triggerall = !AnimTime
trigger1 = Command != "holdup"
value = 243

[State 40, 11]
type = VelSet
trigger1 = !AnimTime
x = IfElse(var(1)= 0, Const(velocity.jump.neu.x), IfElse(var(1)>0, Const(velocity.jump.fwd.x),  Const(velocity.jump.back.x)))
y = Const(velocity.jump.y)

[State 40, 13]
type = ChangeState
trigger1 = !AnimTime
value = 50
ctrl = 1

;-------------------
[Statedef 50]
type    = A
physics = A

[State 50, Fwd]
type = VelSet
trigger1 = !Time && (Var(1) = 2)
x = 4

[State 50, Back]
type = VelSet
trigger1 = !Time && (Var(1) = -2)
x = -4

[State 50, shadow]
type = PlaySnd
triggerall = !Time
trigger1 = var(1) = -2
trigger2 = var(1) = 2
value = 1,4
volume = 0

[State 50, 3]
type = Afterimage
triggerall = Time = 1
triggerall = vel x != 0
trigger1 = var(1) = -2
trigger2 = var(1) = 2
time = 10
PalBright = 0, 0, 0
PalContrast =  250,250,250
PalAdd = 0, 0, 0
PalMul = 1,1,1
Length = 7
FrameGap = 3

[State 50, Control Limiter]
type = ctrlset
triggerall = !Time
trigger1 = prevstateno = 5040
trigger1 = prevstateno = 5210
value = 0

[State 50, Play Sound] 
type = PlaySnd
triggerall = !Time
trigger1 = var(1) != -2
trigger2 = var(1) != 2
value = 1,3

[State 50, 1]
type = VarSet
trigger1 = !Time
sysvar(1) = 0

[State 50, 2]
type = ChangeAnim
trigger1 = !Time
value = ifelse((vel x)=0, 41, ifelse((vel x)>0, 42, 43))

[State 50, 3]
type = ChangeAnim
trigger1 = (Vel y > -2) && SelfAnimExist(anim + 3)
value = Anim + 3
persistent = 0

;--------------------------
[Statedef 243]
type    = A
physics = N
anim = 41
velset = 0, -7 ;-9.47
ctrl = 1

[State 243, Control Limiter] 
type = ctrlset
triggerall = !Time
trigger1 = prevstateno = 5040
trigger1 = prevstateno = 5210
value = 0

[State 243, 1]
type = PlaySnd
triggerall = !Time
trigger1 = var(1) != -2
trigger1 = var(1) != 2
value = 1,3
volume = 0

[State 243, shadow]
type = PlaySnd
triggerall = !Time
trigger1 = var(1) = -2
trigger2 = var(1) = 2
value = 1,4
volume = 0

[State 243, 3] 
type = Afterimage
triggerall = Time = 1
triggerall = vel x > 0
trigger1 = var(1) = -2
trigger2 = var(1) = 2
time = 10
PalBright = 0, 0, 0
PalContrast =  250,250,250
PalAdd = 0, 0, 0
PalMul = 1,1,1
Length = 7
FrameGap = 3

[State 243, 4] 
type = Afterimage
trigger1 = Time = 11
time = 0

[State 243, PUSH]
type = playerpush
triggerall = anim = 41
triggerall = p2statetype != A
triggerall = animelem = 2, >= 0
triggerall = animelem = 5, <= 0
trigger1 = var(1) = -2
trigger2 = var(1) = 2
value = 0

[State 243, AI FwdJmp]
type = VelSet
triggerall = var(33) = 1 && statetype != A
trigger1 = (p2bodydist x = [80,100]) && p2statetype != A
y = -7
x = 3
persistent = 0

[State 243, AI FwdJmp 2]
type = VelSet
triggerall = var(33) = 1 && statetype != A
trigger1 = (p2bodydist x = [101,130]) && p2statetype != L && p2movetype != H
y = -9
x = 3
persistent = 0

[State 243, AI UpJmp]
type = VelSet
triggerall = var(33) = 1 && statetype != A
trigger1 = p2bodydist x <= 30 && p2stateno = 5120
y = -7
x = 0
persistent = 0

[State 243, AI BackJump]
type = VelSet
triggerall = var(33) = 1 && statetype != A
trigger1 = p2bodydist x <= 75 && p2bodydist y >= -80 && p2statetype = A
y = -7
x = -3
persistent = 0

[State 243, 6]
type = VelSet
triggerall = !Time
trigger1 = Var(1) = 1
x = 3

[State 243, 8]
type = VelSet
triggerall = !Time
trigger1 = Var(1) = -1
x = -3

[State 243, 7]
type = VelSet
triggerall = !Time
trigger1 = Var(1) = 2
x = 4

[State 243, 9]
type = VelSet
triggerall = !Time
trigger1 = Var(1) = -2
x = -4

[State 243, 9]
type = Veladd
trigger1 = 1
y = .55

[State 243, 15]
type = Changestate
trigger1 = pos y >= 5
value = 52
ctrl = 0

;---------------------------
[Statedef 52]
type    = S
physics = S
anim = 47
ctrl = 0
velset = 0,0

[State 52, 1]
type = VelSet
trigger1 = !Time
y = 0

[State 52, 2]
type = PosSet
trigger1 = !Time
y = 0

[State 52, 3]
type = PlaySnd
trigger1 = !Time
value = 1,5

[State 52, 4]
type = CtrlSet
trigger1 = time = 1
value = 1

[State 52, 5]
type = turn
triggerall = time = 1 && P2Dist x < 0
trigger1 = command = "holdfwd"
trigger2 = command = "holdback"
trigger3 = command = "holdup"
trigger4 = command = "holddown"

[State 52, 6]
type = ChangeState
trigger1 = !AnimTime
value = 0
ctrl = 1

;--------------------------------------------------------------------------------------------------------------------------
; Run
;--------------------------------------------------------------------------------------------------------------------------

[Statedef 100]
type = S
physics = S
anim = 100
ctrl = 0

[State 100, 2]
type = PlaySnd
trigger1 = !Time
value = 1,2
channel = 3
loop = 1

[State 100, 3]
type = StopSnd
triggerall = var(33) != 1
trigger1 = AnimElem = 2, >= 0
trigger1 = stateno != 100 && command != "holdfwd"
channel = 3

[State 100, VELSET]
type = VelSet
trigger1 = time > 2
x = const(velocity.run.fwd.x)

[State 100, Control]
type = Ctrlset
triggerall = time >= 12
trigger1 = var(33) = 1 
trigger2 = Command != "holdfwd"
trigger3 = command = "holdup" 
trigger4 = command = "holdback" 
value = 1 

[State 100, 5]
type = ChangeState
triggerall = var(33) = 1
triggerall = time >=12
triggerall = p2movetype != H
trigger1 = P2BodyDist x <= 10 
trigger2 = P2MoveType = A
value = 101
ctrl = 1

[State 100, SPECIAL]
type = AssertSpecial
trigger1 = 1
flag = NoWalk 

[State 100, Change State]
type = ChangeState
triggerall = time >= 12
trigger1 = var(33) != 1 && Command != "holdfwd"
value = 101
ctrl = 1

;-------

[Statedef 101]
type = S
physics = S
velset = 0,0
ctrl = 0

[State 101, Velocity]
type = VelMul
trigger1 = !Time
x = 0
y = 0

[State 101, CHANGE ANIMATION]
type = ChangeAnim
trigger1 = !Time
trigger1 = anim != 101
value = 47 

[State 101, End]
type = ChangeState
trigger1 = !AnimTime
value = 0
ctrl = 1

;--------------------------------------------------------------------------------------------------------------------------
; Dash Back
;--------------------------------------------------------------------------------------------------------------------------

[Statedef 105]
type = S
physics = S
anim = 47
velset = 0
ctrl = 0

[State 105, NOTHITBY]
type = NotHitBy
trigger1 = 1
value = SC, AT ; Can't be grabbed while dashing back

[State 105, Next]
type = ChangeState
trigger1 = !AnimTime
value = 106

[Statedef 106]
type = A
physics = N
anim = 105

[State 106, Dash Velocities]
type = VelSet
trigger1 = !Time
x = const(velocity.run.back.x)
y = const(velocity.run.back.y)

[State 106, Dash Back Sound]
type = PlaySnd
trigger1 = !Time
value = 1,6

[State 106, Friction]
type = veladd
trigger1 = time = 10
x = .1

[State 106, Gravity]
type = VelAdd
trigger1 = Time > 2
y = .8

[State 106, End]
type = ChangeState
trigger1 = Vel Y > 0 && Pos Y >= 0
value = 52

[Statedef 107]
type = S
physics = S
anim = 107
velset = 0,0

[State 107, 1]
type = PosSet
trigger1 = !Time
y = 0

[State 107, 2]
type = PlaySnd
trigger1 = !Time
value = 1,5

[State 107, 3]
type = ChangeState
trigger1 = !AnimTime
value = 0
ctrl = 1

;--------------------------------------------------------------------------------------------------------------------------
; Sweep Fall
;--------------------------------------------------------------------------------------------------------------------------

[Statedef 5071]
type    = A
movetype= H
physics = N

[State 5071, Bounce] ; KOF-like.
type = HitVelSet
trigger1 = !Time
x = 1
y = 1

[State 5071, Accel]
type = VelAdd
trigger1 = 1
y = GetHitVar(yaccel)

[State 5071, Recover]
type = ChangeState
triggerall = Vel Y > 0 && Pos Y >= -20
triggerall = alive && CanRecover
trigger1 = Command = "recovery"
value = 5200

[State 5071, Bounce]
type = ChangeState
trigger1 = Vel Y > 0 && Pos Y >= 0
type = ChangeState
value = 5100

;--------------------------------------------------------------------------------------------------------------------------
; Fall Recovery (on ground)
;--------------------------------------------------------------------------------------------------------------------------

[Statedef 5201]
type    = S
movetype= H
physics = S
anim = 5200
ctrl = 0

[State 5201, Clark SND]
type = PlaySnd
trigger1 = !Time
value = 0,22
channel = 0

[State 5201, Turn] ;Turn if not facing opponent
type = Turn
trigger1 = !Time && P2Dist X < -5

[State 5201, VelSet]
type = VelSet
trigger1 = !Time
y = 0

[State 5201, Roll Back Vel]
type = VelSet
trigger1 = Time = [0,12]
x = -4

[State 5201, PosSet]
type = PosSet
trigger1 = !Time
y = 0

[State 5201, Invincible]
type = NotHitBy
trigger1 = 1
value = SCA
time = 1

[State 5201, End]
type = ChangeState
trigger1 = !AnimTime
value = 0
ctrl = 1

;--------------------------------------------------------------------------------------------------------------------------
; GetHit states
;--------------------------------------------------------------------------------------------------------------------------

; HITG_SHAKE
[Statedef 5000]
type    = S
movetype= H
physics = N
velset = 0,0

[State 5000, StopSnd]
type = StopSnd
trigger1 = 1
channel = 3

[State 5000, cheese]
type = AssertSpecial
trigger1 = (prevstateno = [120,152]) && !Time
flag = nokosnd
ignorehitpause = 1

[State 5000, 1] ;Anim for HIT_LIGHT to HIT_HARD
type = ChangeAnim
trigger1 = !Time
trigger1 = GetHitVar(animtype) != [3,5]
value = ifelse((GetHitVar(groundtype) = 1),5000,5010) + GetHitVar(animtype)

[State 5000, 2] ;Anim for HIT_BACK
type = ChangeAnim
trigger1 = !Time
trigger1 = GetHitVar(animtype) = [3,5]
value = 5030

[State 5000, 3] ;Anim for HIT_UP/HIT_DIAGUP (only if it exists)
type = ChangeAnim
trigger1 = !Time
trigger1 = (GetHitVar(animtype) = [4,5]) && (SelfAnimExist(5047 + GetHitVar(animtype)))
value = 5047 + GetHitVar(animtype) ;5051 - 4 + type

[State 5000, 4] ;Freeze anim
type = ChangeAnim
trigger1 = Time > 0
value = anim

[State 5000, 5] ;State type gets set to aerial if getting hit up
type = StateTypeSet
trigger1 = !Time
trigger1 = GetHitVar(yvel) != 0 && GetHitVar(fall)
trigger2 = Pos Y != 0
type = a

[State 5000, 6]
type = ChangeState
trigger1 = HitShakeOver
trigger1 = GetHitVar(yvel) = 0
value = 5001 ;HITG_SLIDE

[State 5000, 7]
type = ChangeState
trigger1 = HitShakeOver
value = 5030

[State 5000, FFB Light]
type = ForceFeedback
trigger1 = anim = 5000
trigger2 = anim = 5010
persistent = 0
time = 6
waveform = square

[State 5000, FFB Medium]
type = ForceFeedback
trigger1 = anim = 5001
trigger2 = anim = 5011
persistent = 0
time = 8
waveform = sinesquare
ampl = 110,-1,-.3

[State 5000, FFB Hard]
type = ForceFeedback
trigger1 = anim = 5012
trigger2 = anim = 5002
trigger3 = anim = 5030
persistent = 0
time = 15
waveform = sinesquare
ampl = 140

;---------------------------------------------------------------------------
; HITG_SLIDE
[Statedef 5001]
type    = S
movetype= H
physics = S

[State 5000, StopSnd]
type = StopSnd
trigger1 = 1
channel = 3

[State 5001, 1]
type = HitVelSet
trigger1 = !Time
x = 1

[State 5001, 2]
type = ChangeAnim
trigger1 = !AnimTime
value = 5005 + GetHitVar(animtype) + (GetHitVar(groundtype)=2)*10

[State 5001, 3] ;Stop sliding back
type = VelMul
trigger1 = Time >= GetHitVar(slidetime)
x = .6

[State 5001, 4]
type = VelSet
trigger1 = HitOver
x = 0

[State 5001, 5]
type = DefenceMulSet
trigger1 = HitOver
value = 1

[State 5001, 6]
type = ChangeState
trigger1 = HitOver
value = 0
ctrl = 1

;---------------------------------------------------------------------------
; HITC_SHAKE
[Statedef 5010]
type    = C
movetype= H
physics = N
velset = 0,0

[State 5000, StopSnd]
type = StopSnd
trigger1 = 1
channel = 3

[State 5010, 1] ;Anim for HIT_LIGHT to HIT_HARD
type = ChangeAnim
trigger1 = !Time
trigger1 = GetHitVar(animtype) != [3,5]
value = 5020 + GetHitVar(animtype)

[State 5010, 2] ;Anim for HIT_BACK
type = ChangeAnim
trigger1 = !Time
trigger1 = GetHitVar(animtype) = [3,5]
value = 5030

[State 5010, 3] ;Anim for HIT_UP/HIT_DIAGUP (only if it exists)
type = ChangeAnim
trigger1 = !Time
trigger1 = (GetHitVar(animtype) = [4,5]) && (SelfAnimExist(5047 + GetHitVar(animtype)))
value = 5047 + GetHitVar(animtype) ;5051 - 4 + type

[State 5010, 4] ;Freeze anim
type = ChangeAnim
trigger1 = Time > 0
value = anim

[State 5010, 5]
type = ChangeState
trigger1 = HitShakeOver
trigger1 = GetHitVar(yvel) = 0
value = 5011 ;HITC_SLIDE

[State 5010, 6]
type = ChangeState
trigger1 = HitShakeOver
value = 5030

[State 5010, FFB Light]
type = ForceFeedback
trigger1 = anim = 5020
persistent = 0
time = 6
waveform = square

[State 5010, FFB Medium]
type = ForceFeedback
trigger1 = anim = 5021
persistent = 0
time = 8
waveform = sinesquare
ampl = 110,-1,-.3

[State 5010, FFB Hard]
type = ForceFeedback
trigger1 = anim = 5022
persistent = 0
time = 15
waveform = sinesquare
ampl = 140

;---------------------------------------------------------------------------
; HITC_SLIDE
[Statedef 5011]
type    = C
movetype= H
physics = C

[State 5000, StopSnd]
type = StopSnd
trigger1 = 1
channel = 3

[State 5011, 1]
type = HitVelSet
trigger1 = !Time
x = 1

[State 5011, 2]
type = ChangeAnim
trigger1 = !AnimTime
value = 5025 + GetHitVar(animtype)

[State 5011, 3] ;Stop sliding back
type = VelMul
trigger1 = Time >= GetHitVar(slidetime)
x = .6

[State 5011, 4]
type = VelSet
trigger1 = HitOver
x = 0

[State 5011, 5]
type = DefenceMulSet
trigger1 = HitOver
value = 1

[State 5011, 6]
type = ChangeState
trigger1 = HitOver
value = 11
ctrl = 1


;---------------------------------------------------------------------------
; HITA_SHAKE
[Statedef 5020]
type    = A
movetype= H
physics = N
velset = 0,0

[State 5000, StopSnd]
type = StopSnd
trigger1 = 1
channel = 3

[State 5020, 1] ;Anim for HIT_LIGHT to HIT_HARD
type = ChangeAnim
trigger1 = !Time
trigger1 = GetHitVar(animtype) != [3,5]
value = ifelse((GetHitVar(airtype) = 1),5000,5010) + GetHitVar(animtype)

[State 5020, 2] ;Anim for HIT_BACK
type = ChangeAnim
trigger1 = !Time
trigger1 = GetHitVar(animtype) = [3,5]
value = 5030

[State 5020, 3] ;Anim for HIT_UP/HIT_DIAGUP (only if it exists)
type = ChangeAnim
trigger1 = !Time
trigger1 = (GetHitVar(animtype) = [4,5]) && (SelfAnimExist(5047 + GetHitVar(animtype)))
value = 5047 + GetHitVar(animtype) ;5051 - 4 + type

[State 5020, 4] ;Freeze anim
type = ChangeAnim
trigger1 = Time > 0
value = anim

[State 5020, 5]
type = ChangeState
trigger1 = HitShakeOver
value = 5030

[State 5020, FFB Light]
type = ForceFeedback
trigger1 = anim = 5000
trigger2 = anim = 5010
persistent = 0
time = 6
waveform = square

[State 5020, FFB Medium]
type = ForceFeedback
trigger1 = anim = 5001
trigger2 = anim = 5011
persistent = 0
time = 8
waveform = sinesquare
ampl = 110,-1,-.3

[State 5020, FFB Hard]
type = ForceFeedback
trigger1 = anim = 5012
trigger2 = anim = 5002
trigger3 = anim = 5030
trigger4 = anim = [5051,5059]
persistent = 0
time = 15
waveform = sinesquare
ampl = 140

;---------------------------------------------------------------------------
; HITA_UP (initial going up)
[Statedef 5030]
type    = A
movetype= H
physics = N
ctrl = 0

[State 5000, StopSnd]
type = StopSnd
trigger1 = 1
channel = 3

[State 5030, 1]
type = VelAdd;Gravity
trigger1 = 1
y = GetHitVar(yaccel)

[State 5030, 2]
type = HitVelSet
trigger1 = !Time
x = 1
y = 1

[State 5030, 3]
type = ChangeState
triggerall = !HitFall
trigger1 = HitOver
trigger2 = Vel Y > 0    ;Hit ground
trigger2 = Pos Y >= 10  ;.
value = 5040 ;HITA_RECOV

[State 5030, 4]
type = ChangeState
triggerall = HitFall
trigger1 = HitOver
trigger2 = Vel Y > 0    ;Hit ground
trigger2 = Pos Y >= 10  ;.
value = 5050 ;HITA_FALL

[State 5030, 5]
type = ChangeState
trigger1 = !AnimTime
value = 5035 ;HITA_UP (transition)

;---------------------------------------------------------------------------
; HITA_UP_T (transition)
[Statedef 5035]
type    = A
movetype= H
physics = N

[State 5000, StopSnd]
type = StopSnd
trigger1 = 1
channel = 3

[State 5035, 1]
type = ChangeAnim
trigger1 = !Time
trigger1 = SelfAnimExist(5035)
trigger1 = Anim != [5051,5059] ;Not if in hit up anim
trigger1 = Anim != 5090 ;Not if hit off ground anim
value = 5035

[State 5035, 2]
type = VelAdd
trigger1 = 1
y = GetHitVar(yaccel)

[State 5035, 3]
type = ChangeState
triggerall = !HitFall
trigger1 = HitOver  ;Hit is over
trigger2 = !AnimTime ;Animation over
trigger3 = Vel Y > 0    ;Hit ground
trigger3 = Pos Y >= 10  ;.
trigger4 = !Time     ;No transition anim
trigger4 = Anim != 5035 ;.
value = 5040 ;HITA_RECOV

[State 5035, 4]
type = ChangeState
triggerall = HitFall
trigger1 = HitOver  ;Hit is over
trigger2 = !AnimTime ;Anim is over
trigger3 = Vel Y > 0    ;Hit ground
trigger3 = Pos Y >= 10  ;.
trigger4 = !Time     ;No transition anim
trigger4 = Anim != 5035 ;.
value = 5050 ;HITA_FALL

;---------------------------------------------------------------------------
; HITA_RECOV (recovering in air, not falling)
[Statedef 5040]
type    = A
movetype= H
physics = N
ctrl = 0

[State 5040, Run]
type = StopSnd
trigger1 = !Time
channel = 3

[State 5040, Invincible]
type = NotHitBy
trigger1 = 1
value = SCA

[State 5040, 1]
type = ChangeState
trigger1 = !Alive
value = 5050

[State 5040, 2]
type = ChangeAnim
trigger1 = !AnimTime
trigger1 = Anim != 5040
trigger2 = !Time
trigger2 = Anim != 5035
value = 5040

[State 5040, 4]
type = StateTypeSet
trigger1 = HitOver
movetype = I

[State 5040, 5]
type = VelAdd
trigger1 = 1
y = GetHitVar(yaccel)

[State 5040, 6]
type = ChangeState
trigger1 = Vel Y > 0
trigger1 = Pos Y >= 0
value = 52 ;JUMPLAND

;---------------------------------------------------------------------------
; HITA_FALL (knocked up, falling)
[Statedef 5050]
type    = A
movetype= H
physics = N

[State 5000, StopSnd]
type = StopSnd
trigger1 = 1
channel = 3

[State 5050, 1] ;Change anim when done with transition
type = ChangeAnim
trigger1 = !AnimTime
trigger1 = Anim = 5035
trigger2 = !Time     ;If no transition anim
trigger2 = Anim != 5035
trigger2 = (Anim != [5051, 5059]) && (Anim != [5061, 5069])
trigger2 = Anim != 5090 ;Not if hit off ground anim
value = 5050

[State 5050, 2] ;Coming down anim
type = ChangeAnim
trigger1 = anim = [5050,5059]
trigger1 = Vel Y >= ifelse(anim = 5050, 1, -2)
trigger1 = SelfAnimExist(anim+10)
value = anim+10
persistent = 0

[State 5050, 3] ;Gravity
type = VelAdd
trigger1 = 1
y = GetHitVar(yaccel)

[State 5050, 4] ;Recover near ground
type = ChangeState
triggerall = Vel Y > 0
triggerall = Pos Y >= -20
triggerall = alive
triggerall = CanRecover
trigger1 = Command = "recovery"
value = 5200 ;HITFALL_RECOVER

[State 5050, 5]; Recover in mid air
type = ChangeState
triggerall = Vel Y > -1
triggerall = alive
triggerall = CanRecover
trigger1 = Command = "recovery"
value = 5210 ;HITFALL_AIRRECOVER

[State 5050, 6]
type = ChangeState
trigger1 = Vel Y > 0
trigger1 = Pos Y >= ifelse((anim = [5051,5059]) || (anim = [5061,5069]), 0, 25)
value = 5100 ;HIT_BOUNCE

;---------------------------------------------------------------------------
; HIT_TRIP (shaking)
[Statedef 5070]
type    = A
movetype= H
physics = N
velset = 0,0

[State 5000, StopSnd]
type = StopSnd
trigger1 = 1
channel = 3

[State 5070, 1]
type = ChangeAnim 
trigger1 = 1
value = 5070

[State 5070, 2]
type = ChangeState
trigger1 = HitShakeOver
value = 5071

[State 5070, 3]
type = ForceFeedback
trigger1 = !Time
time = 12
waveform = sinesquare
ampl = 140

;---------------------------------------------------------------------------
; HIT_TRIP2 (fall through air)
[Statedef 5071]
type    = A
movetype= H
physics = N

[State 5000, StopSnd]
type = StopSnd
trigger1 = 1
channel = 3

[State 5071, 1]
type = HitVelSet
trigger1 = !Time
x = 1
y = 1

[State 5071, 2] ;Acceleration
type = VelAdd
trigger1 = 1
y = GetHitVar(yaccel)

[State 5071, 3] ;Hit ground
trigger1 = Vel Y > 0
trigger1 = Pos Y >= 15
type = ChangeState
value = 5110

;---------------------------------------------------------------------------
; HITL_SHAKE
[Statedef 5080]
type    = L
movetype= H
physics = N
velset = 0,0

[State 5000, StopSnd]
type = StopSnd
trigger1 = 1
channel = 3

[State 5080, 1] ;Set default anim
type = VarSet
trigger1 = !Time
sysvar(2) = ifelse (GetHitVar(yvel) = 0, 5080, 5090)

[State 5080, 2]
type = VarAdd
trigger1 = !Time
trigger1 = (anim = [5081,5089]) || (anim = [5111,5119])
trigger1 = SelfAnimExist(sysvar(2) + (anim % 10))
sysvar(2) = anim % 10

[State 5080, 3] ;If 5090 doesn't exist, default to 5030
type = VarSet
trigger1 = !Time
trigger1 = sysvar(2) = 5090
trigger1 = !SelfAnimExist(5090)
sysvar(2) = 5030

[State 5080, 3] ;Freeze
type = ChangeAnim
trigger1 = 1
value = sysvar(2)

[State 5080, 4]
type = ChangeState
trigger1 = HitShakeOver
trigger1 = GetHitVar(yvel) = 0
value = 5081 ;HITL_SLIDE

[State 5080, 5]
type = ChangeState
trigger1 = HitShakeOver
trigger1 = GetHitVar(yvel) != 0
value = 5030 ;HITA_UP

;---------------------------------------------------------------------------
; HITL_SLIDE
[Statedef 5081]
type    = L
movetype= H
physics = C

[State 5000, StopSnd]
type = StopSnd
trigger1 = 1
channel = 3

[State 5081, 1]
type = HitVelSet
trigger1 = !Time
x = 1

[State 5081, 2]
type = VelSet
trigger1 = HitOver
x = 0

[State 5081, 3] ;Don't show hit ground frame
type = VarSet
trigger1 = !Time
sysvar(0) = 1

[State 5081, 4]
type = ChangeState
trigger1 = HitOver
value = 5110 ;HIT_LIEDOWN

;---------------------------------------------------------------------------
; HIT_BOUNCE (hit ground)
[Statedef 5100]
type    = L
movetype= H
physics = N

[State 5000, StopSnd]
type = StopSnd
trigger1 = 1
channel = 3

[State 5100, 1]
type = VelSet
trigger1 = !Time
trigger1 = GetHitVar(fall.yvel) = 0
trigger1 = vel x > 1
x = 1

[State 5100, EnvShake]
type = FallEnvShake
trigger1 = !Time

[State 5100, Var] ;Save fall velocity
type = VarSet
trigger1 = !Time
;trigger1 = GetHitVar(fall.yvel) = 0
sysvar(1) = floor(vel y)

[State 5100, 2] ;Hit ground anim (normal)
type = ChangeAnim
triggerall = !Time
trigger1 = (anim != [5051,5059]) && (anim != [5061,5069])
trigger2 = !SelfAnimExist(5100 + (anim % 10))
value = 5100

[State 5100, 3] ;Hit ground anim (for hit up)
type = ChangeAnim
trigger1 = !Time
trigger1 = (anim = [5051,5059]) || (anim = [5061,5069])
trigger1 = SelfAnimExist(5100 + (anim % 10))
value = 5100 + (anim % 10)

[State 5100, 4]
type = PosSet
trigger1 = !Time
y = 0

[State 5100, 5]
type = VelSet
trigger1 = !Time
y = 0

[State 5100, 6] ;Reduce speed
type = VelMul
trigger1 = !Time
x = 0.75

[State 5100, 7]
type = ChangeState
trigger1 = !Time
trigger1 = GetHitVar(fall.yvel) = 0
value = 5110 ;HIT_LIEDOWN

[State 5100, 8]
type = GameMakeAnim
trigger1 = Time = 1
;value = 61
;pos = 0, 0
;under = 1
value = 60 + (sysvar(1) > 5) + (sysvar(1) > 14)
pos = 0, 0
under = sysvar(1) <= 10

[State 5100, 9]
type = HitFallDamage
trigger1 = Time = 3

[State 5100, 10]
type = PlaySnd
trigger1 = Time = 1
;value = F7, 0 ;Hit ground
value = F7, (sysvar(1) > 5) + (sysvar(1) > 14)

[State 5100, 11]
type = PosFreeze
trigger1 = 1

[State 5100, 12]
type = ChangeState
trigger1 = !AnimTime
value = 5101

[State 5100, 13]
type = ForceFeedback
trigger1 = !Time
waveform = sinesquare
ampl = 128,-3,-.2,.005
time = 20

;---------------------------------------------------------------------------
; HIT_BOUNCE (bounce into air)
[Statedef 5101]
type    = L
movetype= H
physics = N

[State 5000, StopSnd]
type = StopSnd
trigger1 = 1
channel = 3

[State 5101, 1] ;Coming hit ground anim (normal)
type = ChangeAnim
triggerall = !Time
trigger1 = anim != [5101,5109]
trigger2 = !SelfAnimExist(5160 + (anim % 10))
value = 5160

[State 5101, 2] ;Coming hit ground anim (for hit up)
type = ChangeAnim
triggerall = !Time
trigger1 = anim = [5101,5109]
trigger1 = SelfAnimExist(5160 + (anim % 10))
value = 5160 + (anim % 10)

[State 5101, 3]
type = HitFallVel
trigger1 = !Time

[State 5101, 4]
type = PosSet
trigger1 = !Time
y = 20

[State 5101, 5] ;Acceleration
type = VelAdd
trigger1 = 1
y = .4

[State 5101, 6] ;Hit ground
trigger1 = Vel Y > 0
trigger1 = Pos Y >= 12
type = ChangeState
value = 5110

;---------------------------------------------------------------------------
; HIT_LIEDOWN
[Statedef 5110]
type    = L
movetype= H
physics = N

[State 5150, 1] ;Collapse fix
type = PosAdd
trigger1 = PrevStateNo = 5130
trigger1 = Anim = 5112
x = 80
persistent = 0

[State 5150, StopSnd]
type = StopSnd
trigger1 = 1
channel = 3

[State 5110, EnvShake]
type = FallEnvShake
trigger1 = !Time

[State 5110, 1] ;For hit up/up-diag type (from state 5081)
type = ChangeAnim
persistent = 0
trigger1 = SelfAnimExist(5110 + (anim % 10))
trigger1 = anim = [5081,5089]
value = 5110 + (anim % 10)

[State 5110, 2] ;Hit ground anim (normal)
type = ChangeAnim
triggerall = !Time
triggerall = anim != [5110,5119] ;Not already changed anim
trigger1 = anim != [5161,5169]
trigger2 = !SelfAnimExist(5170 + (anim % 10))
value = 5170

[State 5110, 3] ;Hit ground anim (for hit up)
type = ChangeAnim
triggerall = !Time
triggerall = anim != [5110,5119] ;Not already changed anim
trigger1 = anim = [5161,5169]
trigger1 = SelfAnimExist(5170 + (anim % 10))
value = 5170 + (anim % 10)

[State 5110, 4]
type = HitFallDamage
trigger1 = !Time

[State 5110, 5]
type = PosSet
trigger1 = !Time
y = 0

[State 5110, Var] ;Get fall velocity
type = VarSet
trigger1 = !Time
trigger1 = GetHitVar(fall.yvel) != 0
sysvar(1) = floor(vel y)

[State 5110, 6]
type = PlaySnd
trigger1 = !Time
trigger1 = !SysVar(0)
;value = F7, 0 ;Hit ground
value = F7, (sysvar(1) > 5) + (sysvar(1) > 14)

[State 5110, 7]
type = GameMakeAnim
trigger1 = !Time
trigger1 = !SysVar(0)
value = 60 + (sysvar(1) > 5) + (sysvar(1) > 14)
pos = 0, 0
under = sysvar(1) <= 10

[State 5110, 8]
type = VelSet
trigger1 = !Time
y = 0

[State 5110, 9] ;For hit up type
type = ChangeAnim
persistent = 0
triggerall = anim = [5171,5179]
triggerall = SelfAnimExist(5110 + (anim % 10))
trigger1 = !AnimTime
trigger2 = SysVar(0) ;SysVar(0) = 1 avoids hit ground anim
value = 5110 + (anim % 10)

[State 5110, 10] ;For normal
type = ChangeAnim
persistent = 0
triggerall = Anim != [5111,5119]
trigger1 = !AnimTime
trigger2 = SysVar(0) ;SysVar(0) = 1 avoids hit ground frame
value = 5110

[State 5110, 11] ;If just died
type = ChangeState
triggerall = !alive
trigger1 = !AnimTime
trigger2 = SysVar(0) ;SysVar(0) = 1 avoids hit ground frame
trigger3 = Anim = [5110,5119]
value = 5150

[State 5110, 12]
type = VarSet
trigger1 = SysVar(0)
trigger1 = !Time
sysvar(0) = 0

[State 5110, 13] ;Friction
type = VelMul
trigger1 = 1
x = 0.85

[State 5110, 14]
type = ForceFeedback
trigger1 = alive
trigger1 = !Time
time = 8
ampl = 240
waveform = sine

[State 5110, 15]
type = ForceFeedback
trigger1 = !alive
trigger1 = !Time
ampl = 200, 7, -.467
time = 30
waveform = sine

;---------------------------------------------------------------------------
; HIT_LIEDEAD
[Statedef 5150]
type    = L
movetype= H
physics = N
sprpriority = -3

[State 5150, 1] ;Collapse
type = ChangeAnim
trigger1 = PrevStateNo = 5130
trigger1 = !Time
value = 5112

[State 5150, 1] ;Collapse
type = PosAdd
trigger1 = PrevStateNo = 5130
trigger1 = !Time
x = 40

[State 5150, 1] ;Normal anim
type = ChangeAnim
triggerall = !Time
triggerall = SelfAnimExist(5140)
trigger1 = (anim != [5111,5119]) && (anim != [5171,5179])
trigger2 = !SelfAnimExist(5140 + (anim % 10))
value = 5140

[State 5150, 3] ;Hit up type anim
type = ChangeAnim
trigger1 = !Time
trigger1 = (anim = [5111,5119]) || (anim = [5171,5179])
trigger1 = SelfAnimExist(5140 + (anim % 10))
value = 5140 + (anim % 10)

[State 5150, 4] ;Match over anim
type = ChangeAnim
persistent = 0
;trigger1 = !Time
trigger1 = MatchOver = 1
trigger1 = Anim = [5140,5149]
trigger1 = SelfAnimExist(anim+10)
value = anim+10

[State 5150, 5] ;Switch to 5110 if liedead anim does not exist
type = ChangeAnim
trigger1 = !Time
trigger1 = PrevStateNo != 133
trigger1 = Anim != [5140,5159]
trigger1 = Anim != [5110,5119]
value = 5110

[State 5150, 6] ;Friction
type = VelMul
trigger1 = 1
x = 0.85

[State 5150, 7] ;Friction
type = VelSet
trigger1 = Vel x < .05
persistent = 0
x = 0

[State 5150, 8]
type = NotHitBy
trigger1 = 1
value = SCA
time = 1

;--------------------------------------------------------------------------------------------------------------------------
; Cheese Kill
;--------------------------------------------------------------------------------------------------------------------------

[Statedef 5130]
type = S
physics = S
anim = 5130
poweradd = 0
sprpriority = -1
velset = 0,0
ctrl = 0
;facep2 = 1

[State 5130, cheese 2]
type = AssertSpecial
trigger1 = 1
flag = nokosnd
ignorehitpause = 1

[State 5130, Snd]
type = PlaySnd
trigger1 = time = 10
value = 0,29
channel = 0

[State 5130, air] ; Prevents Cheese Kill from being displayed if Clark got killed in air.
type = Changestate
trigger1 = pos Y != 0
value = 5000

[State 5130, 2]
type = ChangeState
trigger1 = !AnimTime
value = 5150

;--------------------------------------------------------------------------------------------------------------------------
; Variables Reset
;--------------------------------------------------------------------------------------------------------------------------

[Statedef 5900]
type = S

[State 5900, 2]
type = VarRangeSet
trigger1 = roundno = 1
fvalue = 0

[State 5900, Turns Mode Intro]
type = ChangeState
trigger1 = teammode = turns
trigger1 = roundno > 1
trigger1 = roundsexisted <= 0
trigger1 = roundstate = 0
value = 191

[State 5900, 3]
type = ChangeState
trigger1 = roundno = 1
value = 190
;--------------------------------------------------------------------------------------------------------------------------


;--------------------------------------------------------------------------------------------------------------------------
; Lose by Time Over
;--------------------------------------------------------------------------------------------------------------------------

[Statedef 170]
type = S
ctrl = 0
anim = 170
velset = 0,0

[State 170, 1]
type = NotHitBy
trigger1 = 1
value = SCA
time = 1
